/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.reflect;

import com.andavin.reflect.ClassResolver;
import com.andavin.reflect.FieldMatcher;
import com.andavin.reflect.LegacyClassResolver;
import com.andavin.reflect.MethodMatcher;
import com.andavin.reflect.exception.UncheckedClassNotFoundException;
import com.andavin.reflect.exception.UncheckedIllegalAccessException;
import com.andavin.reflect.exception.UncheckedInstantiationException;
import com.andavin.reflect.exception.UncheckedInvocationTargetException;
import com.andavin.reflect.exception.UncheckedNoSuchFieldException;
import com.andavin.reflect.exception.UncheckedNoSuchMethodException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Reflection {
    private static final ClassResolver CLASS_RESOLVER = new LegacyClassResolver();
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap(10);

    private Reflection() {
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws SecurityException, UncheckedInstantiationException, UncheckedNoSuchMethodException, UncheckedIllegalAccessException, UncheckedInvocationTargetException {
        if (params.length == 0) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw Reflection.wrapException(e);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        Class<?>[] classes = Reflection.getClassesForObjects(params);
        return Reflection.newInstance(Reflection.findConstructor(clazz, classes), params);
    }

    public static <T> T newInstance(Constructor<T> con, Object ... params) throws SecurityException, UncheckedInstantiationException, UncheckedIllegalAccessException, UncheckedInvocationTargetException {
        if (!con.isAccessible()) {
            con.setAccessible(true);
        }
        try {
            return con.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw Reflection.wrapException(e);
        }
    }

    public static <T> T getFieldValue(Class<?> clazz, Object instance, String name) throws ClassCastException, SecurityException, UncheckedNoSuchFieldException, UncheckedIllegalAccessException {
        return Reflection.getFieldValue(Reflection.findField(clazz, name), instance);
    }

    public static <T> T getFieldValue(Field field, Object instance) throws ClassCastException, SecurityException, UncheckedIllegalAccessException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw Reflection.wrapException(e);
        }
    }

    public static void setFieldValue(Class<?> clazz, Object instance, String name, Object value) throws SecurityException, UncheckedNoSuchFieldException, UncheckedIllegalAccessException {
        Reflection.setFieldValue(Reflection.findField(clazz, name), instance, value);
    }

    public static void setFieldValue(Field field, Object instance, Object value) throws SecurityException, UncheckedIllegalAccessException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw Reflection.wrapException(e);
        }
    }

    public static Field findField(Class<?> clazz, String name) throws UncheckedNoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldException exception = e;
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz != null && superClazz != Object.class) {
                try {
                    return superClazz.getField(name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            throw Reflection.wrapException(exception);
        }
    }

    public static Field findField(Class<?> clazz, FieldMatcher matcher) throws UncheckedNoSuchFieldException {
        return Reflection.findField(clazz, 0, matcher);
    }

    public static Field findField(Class<?> clazz, int index, FieldMatcher matcher) throws IndexOutOfBoundsException, UncheckedNoSuchFieldException {
        Field[] fields;
        int found = 0;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!matcher.match(field) || found++ != index) continue;
            return field;
        }
        if (found < index) {
            throw new IndexOutOfBoundsException("Too few matching fields to reach " + index + " in " + clazz.getSimpleName());
        }
        throw matcher.buildException();
    }

    public static <T> T invokeMethod(Class<?> clazz, Object instance, String name, Object ... params) throws ClassCastException, SecurityException, UncheckedNoSuchMethodException, UncheckedIllegalAccessException, UncheckedInvocationTargetException {
        return Reflection.invokeMethod(Reflection.findMethod(clazz, name, Reflection.getClassesForObjects(params)), instance, params);
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... params) throws ClassCastException, SecurityException, UncheckedIllegalAccessException, UncheckedInvocationTargetException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)method.invoke(instance, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Reflection.wrapException(e);
        }
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        return Reflection.findMethod(clazz, name, true, paramTypes);
    }

    public static Method findMethod(Class<?> clazz, String name, boolean hierarchyMatch, Class<?> ... paramTypes) throws UncheckedNoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            if (hierarchyMatch) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (method.getParameterCount() != paramTypes.length || !method.getName().equals(name) || !Reflection.compare(method.getParameterTypes(), paramTypes, false)) continue;
                    return method;
                }
            }
            NoSuchMethodException exception = e;
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz == null) {
                throw Reflection.wrapException(exception);
            }
            try {
                return superClazz.getMethod(name, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (hierarchyMatch) {
                    for (Method method : superClazz.getMethods()) {
                        if (!method.getName().equals(name) || method.getParameterCount() != paramTypes.length || !Reflection.compare(method.getParameterTypes(), paramTypes, false)) continue;
                        return method;
                    }
                }
                throw Reflection.wrapException(exception);
            }
        }
    }

    public static Method findMethod(Class<?> clazz, MethodMatcher matcher) throws UncheckedNoSuchMethodException {
        return Reflection.findMethod(clazz, 0, matcher);
    }

    public static Method findMethod(Class<?> clazz, int index, MethodMatcher matcher) throws IndexOutOfBoundsException, UncheckedNoSuchMethodException {
        Method[] methods;
        int found = 0;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!matcher.match(method) || found++ != index) continue;
            return method;
        }
        if (found < index) {
            throw new IndexOutOfBoundsException("Too few matching methods to reach " + index + " in " + clazz.getSimpleName());
        }
        throw matcher.buildException();
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... paramTypes) throws UncheckedNoSuchMethodException {
        return Reflection.findConstructor(clazz, true, paramTypes);
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean hierarchyMatch, Class<?> ... paramTypes) throws UncheckedNoSuchMethodException {
        try {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            if (!hierarchyMatch) {
                throw Reflection.wrapException(e);
            }
            NoSuchMethodException exception = e;
            for (Constructor<?> con : clazz.getDeclaredConstructors()) {
                if (con.getParameterCount() != paramTypes.length || !Reflection.compare(con.getParameterTypes(), paramTypes, false)) continue;
                return con;
            }
            throw Reflection.wrapException(exception);
        }
    }

    public static <T> Class<T> findClass(String name) throws UncheckedClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw Reflection.wrapException(e);
        }
    }

    public static String getCallerClass() {
        return Reflection.getCallerClass(1, Collections.emptySet());
    }

    public static String getCallerClass(int index, Class<?> ... exclude) {
        Set<String> excluded;
        if (exclude.length != 0) {
            excluded = new HashSet<String>((int)((double)exclude.length / 0.75));
            for (Class<?> clazz : exclude) {
                excluded.add(clazz.getName());
            }
        } else {
            excluded = Collections.emptySet();
        }
        return Reflection.getCallerClass(++index, excluded);
    }

    public static String getCallerClass(int index, Set<String> excluded) {
        String name = CLASS_RESOLVER.resolve(++index);
        while (excluded.contains(name)) {
            name = CLASS_RESOLVER.resolve(++index);
        }
        return name;
    }

    public static boolean compare(Class<?>[] primary, Class<?>[] secondary, boolean exact) {
        if (primary.length != secondary.length) {
            return false;
        }
        if (primary.length == 0) {
            return true;
        }
        for (int i = 0; i < primary.length; ++i) {
            Class<?> primaryType = primary[i];
            Class<?> secondaryType = secondary[i];
            if (exact) {
                if (primaryType == secondaryType) continue;
                return false;
            }
            if (primaryType.isAssignableFrom(secondaryType)) continue;
            boolean primaryTypePrimitive = primaryType.isPrimitive();
            boolean secondaryTypePrimitive = secondaryType.isPrimitive();
            if (primaryTypePrimitive || secondaryTypePrimitive) {
                Class<?> type1 = primaryTypePrimitive ? primaryType : PRIMITIVES.get(primaryType);
                Class<?> type2 = secondaryTypePrimitive ? secondaryType : PRIMITIVES.get(secondaryType);
                return type1 == type2;
            }
            return false;
        }
        return true;
    }

    private static Class<?>[] getClassesForObjects(Object ... params) {
        if (params.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] paramClasses = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            paramClasses[i] = param == null ? Void.class : param.getClass();
        }
        return paramClasses;
    }

    private static RuntimeException wrapException(Exception e) {
        if (e instanceof IllegalAccessException) {
            return new UncheckedIllegalAccessException(e.getMessage());
        }
        if (e instanceof InvocationTargetException) {
            return new UncheckedInvocationTargetException(e.getCause(), e.getMessage());
        }
        if (e instanceof InstantiationException) {
            return new UncheckedInstantiationException(e.getMessage());
        }
        if (e instanceof NoSuchMethodException) {
            throw new UncheckedNoSuchMethodException(e.getMessage());
        }
        if (e instanceof NoSuchFieldException) {
            throw new UncheckedNoSuchFieldException(e.getMessage());
        }
        if (e instanceof ClassNotFoundException) {
            throw new UncheckedClassNotFoundException(e.getMessage(), e.getCause());
        }
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static boolean isAtLeastJava9() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return false;
        }
        int index = version.indexOf(46);
        if (index > 0) {
            version = version.substring(0, index);
        }
        return version.matches("[0-9]{1,8}") && Integer.parseInt(version) >= 9;
    }

    static {
        PRIMITIVES.put(Byte.class, Byte.TYPE);
        PRIMITIVES.put(Short.class, Short.TYPE);
        PRIMITIVES.put(Integer.class, Integer.TYPE);
        PRIMITIVES.put(Long.class, Long.TYPE);
        PRIMITIVES.put(Float.class, Float.TYPE);
        PRIMITIVES.put(Double.class, Double.TYPE);
        PRIMITIVES.put(Boolean.class, Boolean.TYPE);
        PRIMITIVES.put(Void.class, Void.TYPE);
    }
}

